/*
 * Decompiled with CFR 0.152.
 */
package sufftracker;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import sufftracker.ContentPanel;
import sufftracker.Contestant;

public class BeamerContestantPanel
extends ContentPanel
implements Runnable {
    long startColorFade = System.currentTimeMillis();
    float old_perc = 0.5f;
    float new_perc = 1.0f;
    float cur_perc = 0.5f;
    private JLabel amountLabel;
    private JLabel nameLabel;
    private JLabel scoreLabel;

    public BeamerContestantPanel(Contestant c) {
        this.initComponents();
        this.setSize(this.getPreferredSize());
        this.contestant = c;
        Thread t = new Thread(this);
        t.start();
        this.nameChanged();
        this.amountChanged();
        this.scoreLabel.setText("--- Punkte");
    }

    @Override
    public void step() {
        super.step();
        double d = (double)(System.currentTimeMillis() - this.startColorFade) / 1000.0;
        if (d > 1.0) {
            d = 1.0;
        }
        this.cur_perc = this.old_perc + (this.new_perc - this.old_perc) * (float)d;
        if ((double)this.cur_perc < 0.5) {
            this.setBackground(new Color(255, (int)(this.cur_perc * 2.0f * 255.0f), 0));
        } else {
            this.setBackground(new Color((int)(255.0f * (2.0f - this.cur_perc * 2.0f)), 255, 0));
        }
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.amountLabel = new JLabel();
        this.scoreLabel = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(111, 100));
        this.nameLabel.setFont(new Font("Cambria", 0, 24));
        this.nameLabel.setHorizontalAlignment(0);
        this.nameLabel.setText("Person A");
        this.amountLabel.setFont(new Font("Cambria", 0, 24));
        this.amountLabel.setHorizontalAlignment(4);
        this.amountLabel.setText("99 Bier");
        this.scoreLabel.setFont(new Font("Cambria", 0, 18));
        this.scoreLabel.setHorizontalAlignment(4);
        this.scoreLabel.setText("99 Punkte");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scoreLabel, -1, 87, Short.MAX_VALUE).addComponent(this.amountLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.nameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.amountLabel, -2, 22, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.scoreLabel).addContainerGap()));
    }

    @Override
    protected void plusOne() {
    }

    @Override
    public void setCurrentMax(int m) {
        this.startColorFade = System.currentTimeMillis();
        this.old_perc = this.cur_perc;
        this.new_perc = (float)(this.contestant.latest.amount == 0 ? 1 : this.contestant.latest.amount) / (float)m;
    }

    @Override
    public void amountChanged() {
        this.amountLabel.setText(this.contestant.latest.amount + "  Bier");
    }

    @Override
    public void nameChanged() {
        this.nameLabel.setText(this.contestant.latest.person);
    }
}

